# 파일 시스템

- `파일(File)`
    - **논리적인 저장 단위로, 관련된 정보 자료들의 집합에 이름을 붙인 것**이다.  
    - 일반적으로 레코드(Record) 혹은 블록(Block) 단위로 비휘발성 보조기억장치에 저장된다.  
    - 파일이 생성되고 기록되는 등 모든 과정은 운영체제에 의해서만 통제된다. 
    - 응용프로그램은 시스템 호출을 통해서만 파일 시스템을 사용할 수 있다.  

- `파일 속성(File Attribute)`, `파일 메타데이터(File Metadata)`
    - **파일을 관리하기 위한 각종 정보들이다.** 파일 자체의 내용은 아니다.  
    - 파일 이름, 유형, 저장된 위치, 파일 사이즈, 접근 권한, 소유자, 시간(생성/변경/사용) 등 파일에 대한 전반적인 정보를 말한다. 

- `파일 시스템(File System)`
    - **운영체제와 모든 데이터, 프로그램의 저장과 접근을 위한 기법을 제공**한다.  
    - 시스템 내의 모든 파일에 관한 정보를 제공하는 계층적 디렉터리 구조이고, 파일 및 파일의 메타데이터, 디렉터리 정보 등을 관리한다.

- `파일 시스템 메타데이터(File System Metadata)`
    - `파일 시스템 전체에 대한 정보`이다.
    - 파일 시스템 크기, 저장 장치에 구축된 파일 시스템의 현재 사용중인 크기, 저장 장치에 구축된 파일 시스템의 비어있는 크기 등 이다.

- `파티션(Partition)`
    - **연속된 저장 공간을 하나 이상의 연속되고 독립적인 영역으로 나누어 사용할 수 있도록 정의한 규약**이다.
    - 하나의 물리적 디스크 안에 여러 파티션을 두는 게 일반적이지만, 여러 물리적 디스크를 하나의 파티션으로 구성하기도 한다. 

<br>

## 접근 기법
시스템이 제공하는 파일 정보의 접근 방식은 **순차 접근(Sequential Access)**, **직접 접근(Direct Access, Random Access)**, **색인 접근(Index Access)** 으로 나뉜다. 

<br>

### 1. 순차 접근(Sequential Access)  
가장 단순한 방법으로 파일의 정보가 레코드 순서대로 처리된다.  
현재 위치에서 읽거나 쓰면 offset이 자동으로 증가하고, 뒤로 돌아가기 위해선 되감기가 필요하다.  
<img src="https://user-images.githubusercontent.com/70997596/215400535-89eec3a2-004f-4477-8031-545a1b452923.png" width="500">  


### 2. 직접 접근(Random Access)  
파일의 레코드를 임의의 순서로 접근할 수 있다.  
읽기나 쓰기의 순서에 제약이 없으며 현재 위치를 유지할 수 있다면 이를 통해 순차 접근 기능도 구현할 수 있다.  

### 3. 색인 접근(Index Access)  
파일에서 레코드를 찾기 위해 색인을 먼저 찾고 대응되는 포인터를 얻는다. 이를 통해 파일에 직접 접근하여 원하는 데이터를 얻을 수 있다.  
따라서 크기가 큰 파일에서 유용하다.  
<img src="https://user-images.githubusercontent.com/70997596/215400547-fcb792ea-f35b-4e8f-9a26-2d882d83d392.png" width="500">  

<br>

## 디렉터리(Directory)와 구조
디렉터리(Directory)는 파일의 메타데이터 중 일부를 보관하고 있는 일종의 특별한 파일이다.  
해당 디렉터리에 속한 파일 이름과 속성들을 포함하고 있고, 다음과 같은 기능들을 제공한다.  

- 파일 찾기(Search)
- 파일 생성(Create)
- 파일 삭제(Delete)
- 디렉터리 나열(List)
- 파일 재명명(Rename)
- 파일 시스템 순회(Traverse)

<br>

### 1단계 디렉터리(Single-Level Directory)  
1단계 디렉터리는 **모든 파일들이 디렉터리 밑에 존재하는 형태**이다.  
파일들은 서로 유일한 이름을 가지고 서로 다른 사용자라도 같은 이름을 사용할 수 없다.  
지원하기도 쉽고 이해하기도 쉽지만, 파일이 많아지거나 다수의 사용자가 사용하는 시스템에서는 심각한 제약을 갖는다.  
<img src="https://user-images.githubusercontent.com/70997596/215400564-76f94a6c-54e8-4cd7-b2e8-3a20c38f5e53.png" width="600">  

### 2단계 디렉터리(Two-Level Directory)  
2단계 디렉터리는 **각 사용자별로 별도의 디렉터리를 갖는 형태**이다.  
서로 다른 사용자가 같은 이름의 파일을 가질 수 있고 효율적인 탐색이 가능하다.  
하지만 그룹화가 불가능하고, 다른 사용자의 파일에 접근해야 하는 경우에는 단점이 된다.  
<img src="https://user-images.githubusercontent.com/70997596/215400584-ffa4c96e-adf4-4325-a2eb-c93f23c1ab52.png" width="600">  

### 트리 구조 디렉터리(Tree-Structured Directory)  
**사용자들이 자신의 서브 디렉터리(Sub-Directory)를 만들어서 파일을 구성할 수 있다.**  
하나의 루트 디렉터리를 가지며 모든 파일은 고유한 경로(절대 경로/상대 경로)를 가진다. 이를 통해 **효율적인 탐색**이 가능하고, **그룹화**가 가능하다.  
디렉터리는 일종의 파일이므로 일반 파일인지 디렉터리인지 구분할 필요가 있다. 이를 bit를 사용하여 0이면 일반 파일, 1이면 디렉터리로 구분한다.   
<img src="https://user-images.githubusercontent.com/70997596/215400596-9108722d-71e9-4726-b24f-631fa0e47af4.png" width="600">  

### 비순환 그래프 디렉터리(Acyclic-Graph Directory)  
**디렉터리들이 서브 디렉터리들과 파일을 공유할 수 있도록 한다.** 트리 구조의 디렉터리를 일반화한 형태이다.  
단순한 트리 구조보다는 더 복잡한 구조이기 때문에 몇몇 문제가 발생할 수 있다.  
파일을 무작정 삭제하게 되면 현재 파일을 가리키는 포인터는 대상이 사라지게 된다.  
따라서 참조되는 파일에 참조 계수를 두어서, 참조 계수가 0이 되면 파일을 참조하는 링크가 존재하지 않는다는 의미이므로 그때 파일을 삭제할 수 있도록 한다.  
<img src="https://user-images.githubusercontent.com/70997596/215400615-a1fccd47-bfc4-4dbb-be0d-82560d3cdb66.png" width="500">

### 일반 그래프 디렉터리(General Graph Directory)  
**순환을 허용하는 그래프 구조**이다. 순환이 허용되면 무한 루프에 빠질 수 있다.  
따라서, 하위 디렉터리가 아닌 파일에 대한 링크만 허용하거나 garbage collection을 통해 전체 파일 시스템을 순회하고, 접근 가능한 모든 것을 표시한다.  
<img src="https://user-images.githubusercontent.com/70997596/215400629-3daf7082-2493-4b3d-99c0-0f2bcbee67e3.png" width="600">

<br>

---
## Reference
- 명품 운영체제, 황기태 저, 생능출판사, 2023 
